<?php
declare(strict_types = 1);
namespace app\cms\controller\admin;

use app\common\model\Tag;
use Webman\Event\Event;

class Part extends Base
{
    protected $conf;
    protected function initialize()
    {
        parent::initialize();
        $this->CheckAuth(['read','create','edit','del'],'admin','cms.Part');
        if(!$this->user_auth['index']){
            $this->response('没有此权限','0');
        }
        $this->BaseModel('Part','model','cms');
        $this->GetConf();
        $this->list_base['base_part'] = 'cms:part';
        switch ($this->request->action){
            case 'index':
                $this->list_base['fast_url'] = GetEruUrl('cms/admin.Part/fastedit',$this->getdata);
                $this->list_base['url'] = GetEruUrl('cms/admin.Part/getlist',$this->getdata);
                $this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                $this->list_base['url'] = GetEruUrl('cms/admin.Part/save',$this->getdata);
                $this->list_base['title'] = $this->request->action == 'edit' ? '编辑' : '添加';
                $this->FormFile();
                break;
        }

    }
    protected function ListTable(){
        $list_file = Event::dispatch('mod.GetAdminList',['mod' => 'part','model' => 'cms']);
        if(empty($list_file['0']['code'])){
            $this->response($list_file['0']['msg'],'0');
        }
        $this->list_file[] = ['type' => 'checkbox','fixed' => 'left','width' => '50'];
        $this->list_file = array_merge($this->list_file,$list_file['0']['filelist']);

        $this->list_base['button'] = [];
        if($this->user_auth['create']) {
            array_push($this->list_base['button'],['title' => '新增', 'open' => true, 'url' => GetEruUrl('cms/admin.Part/create',$this->getdata)]);
        }
        if($this->user_auth['read']) {
            $this->list_file[] = ['field' => 'read', 'title' => '查看', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-querenfangan', 'url' => GetEruUrl('cms/admin.Part/read', ['id' => '__id__']),'fixed' => 'right','open' => true,];
        }
        if($this->user_auth['edit']) {
         $this->list_file[] = ['field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('cms/admin.Part/edit', ['id' => '__id__']),'fixed' => 'right','open' => true,];
        }
        if($this->user_auth['del']) {
            $this->list_file[] = ['field' => 'del', 'title' => '删除', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-delete', 'url' => GetEruUrl('cms/admin.Part/del', ['id' => '__id__']),'fixed' => 'right'];
            $this->list_base['button'][] = ['title' => '批量删除', 'class' => 'ery-bg-red ery-button', 'event' => 'del', 'url' => GetEruUrl('cms/admin.Part/del',['_d' => 'p'])];
        }
        if(isset($this->list_base['fold']) && $this->list_base['fold']){
            array_splice($this->list_file,0,1);
            foreach ($this->list_file as $k => $v){
                if(!empty($v['fixed'])){
                    unset($v['fixed']);
                }
                if(!empty($v['field']) && in_array($v['field'],['addip','addtime','edittime'])){
                    unset($this->list_file[$k]);
                    continue;
                }
                $this->list_file[$k] = $v;
            }
            $this->list_file = array_merge([],$this->list_file);
            if($this->user_auth['del']) {
                $this->list_base['button'] = DelFile($this->list_base['button'],'title','批量删除',true);
            }
        }
        if(!empty($list_file['0']['searchlist'])){
            $this->list_search['select'] = DelFile($list_file['0']['searchlist'],'type','select');
            $this->list_search['input'] = DelFile($list_file['0']['searchlist'],'type','text');
            $this->list_search['date'] = DelFile($list_file['0']['searchlist'],'type','date');
        }
    }
    protected function FormFile(){
        $form_file = Event::dispatch('mod.GetForm',['mod' => 'part','model' => 'cms']);
        if(empty($form_file['0']['code'])){
            $this->response($form_file['0']['msg'],'0');
        }
        $this->list_file = $form_file['0']['filelist'];
        if($this->conf['pages'] == '2'){
            //  查询上级id字段
            $_rank = DelFile($this->list_file,'type','rank');
            if(!empty($_rank)){
                $_rank = $_rank['0']['field'];
                $_partlist = $this->model->GetList(['status' => '1'],false);
                $_pid = ['id' => '','on' => false];
                if(!empty($this->getdata['id']) || !empty($this->getdata[$_rank])){
                    $_pid['id'] = $this->getdata['id'] ?? $this->getdata[$_rank];
                    $_pid['on'] = !empty($this->getdata['id']);
                }
                $_partlist = FormatPart($_partlist,$_pid,['title' => 'title_display']);
                $_partlist = array_merge([['title' => '顶级菜单','value' => '0']],$_partlist);

                foreach ($this->list_file as &$v){
                    if($v['field'] == $_rank){
                        $v['type'] = 'select';
                        $v['list'] = $_partlist;
                        $v['default'] = $this->getdata[$_rank] ?? '';
                    }
                }
            }
        }
        array_push($this->list_file,
            ['field' => 'sort','title' => '排序值','required' => true,'type' => 'number','default' => '0'],
            ['field' => 'uid','title' => 'UID','required' => true,'type' => 'hidden','default' => $this->ImUser['uid']],
            ['field' => 'cid','title' => 'CID','required' => true,'type' => 'hidden','default' => $this->ImUser['cid']],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '草稿','value' => '0'],['title' => '禁用','value' => '2']],'default' => '1','required' => true]
        );
        if($this->request->action == 'edit' || !empty($this->getdata['id'])){
            array_push($this->list_file,['field' => 'id','title' => 'ID','required' => true,'type' => 'hidden']);
        }
        $_group = array_unique(array_column($this->list_file,'group'));
        if(count($_group) > '1'){
            $this->list_nav = [];
            unset($v);
            foreach ($_group as $v) {
                $_k = count($this->list_nav) + 1;
                $_v = $v ?? '基础信息';
                foreach ($this->list_file as &$v1){
                    $v1['group'] = $v1['group'] ?? '';
                    if($v1['group'] == $_v){
                        $v1['group'] = $_k;
                    }
                }
                array_push($this->list_nav,['title' => $_v,'value' => $_k]);
            }
        }
    }
    protected function GetListDbSelf($data){
        $list_file = Event::dispatch('mod.GetAdminList',['mod' => 'part','model' => 'cms']);
        if(empty($list_file['0']['code'])){
            $this->response($list_file['0']['msg'],'0');
        }
        $data['GetFile'] = array_column($list_file['0']['filelist'],'field');
        $data['GetFile'] = array_merge($data['GetFile'],['uid','cid','sort','hist','status','addtime','addip']);
        if($this->conf['pages'] == '2'){
            array_push($data['GetFile'],'pid');
        }
        return $data;
    }
    protected function GetConf(){
        $res = Event::dispatch('mod.GetMod',['mod' => 'part','model' => 'cms']);
        if($res['0']['code'] != '1'){
            $this->response($res['0']['msg'],'0');
        }
        $this->conf = $res['0']['data'];
        switch ($this->conf['pages']){
            case '1':
                $this->list_base['page'] = false;
                break;
            case '2':
                $this->list_base['page'] = false;
                $this->list_base['fold'] = true;
                break;
        }
    }
    public function tag(){
        //  指定模板
        $this->list_base['template'] = "tag:cms_part";
        $res = $this->GetViewFile($this->list_base['template']);
        $this->list_base['code'] = $res['code'];
        //  获取标签
        $_m = new Tag();
        $read = $_m->GetOne($this->getdata['id']);
        if(!empty($this->getdata['init'])){
            $read['TagModular'] = 'cms';
            $read['TagMod'] = 'part';
            $read['latename'] = '';
            $read['template'] = '';
            $read['conf'] = [];
        }
        $form_file = Event::dispatch('mod.GetHomeRead',['mod' => 'part','model' => 'cms']);
        $this->list_file = $form_file['0']['homeread'] ?? [];
        return $this->ResTagForm($read);
    }
}