<?php
declare(strict_types = 1);
namespace app\common\hook;

class ImField
{
    /**
     * 表单格式化操作
     * @array $formlist 要处理的字段列表
     * @array $data 要处理的数据
     * @return $formlist
     */
    public function EditForm($formlist,$data = [])
    {
        foreach ($formlist as &$v) {
            $v['default'] = $v['default'] ?? '';
            $v['default'] = $data[$v['field']] ?? $v['default'];
            $v['type'] = $v['type'] ?? 'text';
            switch ($v['type']){
                case 'select':
                case 'radio':
                    $v['list'] = $this->EditFormList($v['list']);
                    break;
                case 'images':
                case 'files':
                    $v['default'] = is_array($v['default']) ? $v['default'] : (json_decode($v['default'], true) ?: []);
                    break;
                case 'checkbox':
                    $v['default'] = empty($v['default']) ? [] : (is_array($v['default']) ? $v['default'] : explode(',',$v['default']));
                    $v['list'] = $this->EditFormList($v['list']);
                    break;
                case 'getmodel':
                    if (!str_contains($v['geturl'] ?? '', '://')) {
                        if(!empty($v['getclass']) && $v['getclass'] == '1'){
                            $v['getmodel'] = strtr($v['getmodel'], ['/' => '.']);
                            $v['getmodel'] = explode('.', $v['getmodel']);
                            $appname = request()->viewconf['app'] == 'home' ? '' : request()->viewconf['app'];
                            if(count($v['getmodel']) > 1){
                                $v['getmodel'] = empty($appname) ? $v['getmodel'] : ArraySpliceArray($v['getmodel'],1,$appname);
                            } else {
                                $v['getmodel'] = empty($appname) ? $v['getmodel'] : [$appname, ...$v['getmodel']];
                            }
                            $v['getmodel'] = implode('/', $v['getmodel']);
                            $v['geturl'] = GetEruUrl("{$v['getmodel']}/getlist");
                        } else {
                            $v['geturl'] = GetEruUrl($v['geturl']);
                        }
                    }
                    $fieldMap = ['title' => 'title','value' => 'value'];
                    foreach (explode(',', $v['fielddata'] ?? '') as $pair) {
                        [$key, $val] = array_pad(explode('=', $pair, 2), 2, null);
                        if ($key && in_array($key, ['title', 'value'], true)) {
                            $fieldMap[$key] = $val ?? $key;
                        }
                    }
                    $v['fielddata'] = $fieldMap;
                    break;
            }
        }
        unset($v);
        return $formlist;
    }
    public function UntRead($formlist,$data = []){
        foreach ($data as $k => $v){
            $_v = DelFile($formlist,'field',$k);
            if(!empty($_v['0']['type'])) {
                switch ($_v['0']['type']) {
                    case 'images':
                    case 'files':
                        $v = is_array($v) ? $v : json_decode($v, true);
                        break;
                }
            }
            $data[$k] = $v;
        }
        return $data;
    }
    /**
     * 数据保存前进行数据处理
     * @param $formlist
     * @param $data
     * @param array $old
     * @return mixed
     */
    public function SetForm($formlist,$data = [],$old = [],$updir = ''){
        $_data = [];
        foreach ($formlist as $k => $v){
            if(isset($v['required']) && $v['required'] && (empty($data[$v['field']]) && !isset($data[$v['field']]))){
                return ['code' => '0','msg' => "{$v['title']}不得为空"];
            }
            $v['_dir'] = $updir;
            $v['_value'] = isset($old[$v['field']]) ? $old[$v['field']] : null;
            $v['value'] = isset($data[$v['field']]) ? $data[$v['field']] : null;
            if($v['_value'] == $v['value']){
                continue;
            }
            $v = $this->SetFormFiles($v);
            $_data = array_merge($_data,$v);
        }
        $_data = FileEditAdd($_data);
        return ['code' => '1','data' => $_data];
    }
    /**
     * @array $filed_data 转换为储存字段
     */
    protected function SetFormFiles($filed_data){
        $_data[$filed_data['field']] = $filed_data['value'];
        switch ($filed_data['type']){
            case 'editor':
                $img_data = [
                    'oldimg' => empty($filed_data['_value']) ? null : $filed_data['_value'],
                    'newimg' => $filed_data['value'],
                ];
                $_m = new Upload();
                $_data[$filed_data['field']] = $_m->SetEditOr($img_data);
                break;
            case 'text':
                $_data[$filed_data['field']] = $filed_data['value'];
                if(!empty($filed_data['type_edit']) && in_array($filed_data['type_edit'],['date','datetime',])){
                    $_data[$filed_data['field']] = empty($filed_data['value']) ? null : strtotime($filed_data['value']);
                }
                break;
            case 'checkbox':
                $_data[$filed_data['field']] = !isset($filed_data['value']) ? null : implode(',',$filed_data['value']);
                break;
            case 'zips':
            case 'files':
            case 'images':
                $new = CompareFile(empty($filed_data['value']) ? [] : $filed_data['value'],empty($filed_data['_value']) ? [] : FileEditAdd(is_array($filed_data['_value']) ? $filed_data['_value'] : json_decode($filed_data['_value'],true),false),'url');
                $_new = array_column($new['new'],'url');
                if(!empty($_new)){
                    $_m = new Upload();
                    foreach ($filed_data['value'] as $k => $v){
                        if(!in_array($v['url'],$_new)){
                            continue;
                        }else if(empty($v['url'])){
                            unset($filed_data['value'][$k]);
                            continue;
                        }
                        $v['url'] = $_m->fileMove($v['url'],empty($filed_data['_dir']) ? '' : $filed_data['_dir']);
                        $filed_data['value'][$k] = $v;
                    }
                }
                if(!empty($filed_data['value'])){
                    sort($filed_data['value']);
                }
                $_data[$filed_data['field']] = empty($filed_data['value']) ? '' : json_encode(FileEditAdd($filed_data['value']),JSON_UNESCAPED_UNICODE);
                $_new = empty($new['old']) ? [] : array_column($new['old'],'url');
                if(!empty($_new)){
                    DelWebFile($_new);
                }
                break;
            case 'zip':
            case 'file':
            case 'image':
                $filed_data['_value'] = FileEditAdd($filed_data['_value'],false);
                if($filed_data['_value'] != $filed_data['value']){
                    $_m = new Upload();
                    $_data[$filed_data['field']] = $_m->fileMove($filed_data['value'],empty($filed_data['_dir']) ? [] : ['file_dir' => $filed_data['_dir']]);
                    $filed_data['_value'] = empty($filed_data['_value']) ? '' : DelWebFile($filed_data['_value']);
                }
                break;
        }
        return $_data;
    }
    /**
     * 处理多选项，如果多选列表不是数组，则进行格式化
     * @param $data
     * @return array|mixed
     */
    protected function EditFormList($data){
        if(empty($data)){
            return [];
        }
        if(!is_array($data)){
            $lines = explode("\n", str_replace(["\r\n", "\r"], "\n", $data));
            $data = [];
            foreach ($lines as &$line){
                $line = trim($line);
                if ($line === ''){
                    continue;
                }
                $parts = array_map('trim', explode('|', $line, 2));
                $data[] = count($parts) > 1 ? ['value' => $parts[0], 'title' => $parts[1]] : ['value' => $line, 'title' => $line];
            }
        }
        return $data;
    }
}