<?php
declare(strict_types = 1);
namespace app\common\model;

use think\facade\Db;
use support\Cache;

class ModularField extends R
{
    protected $_order = 'sort desc,id asc';
    protected function UntModel($data){
        //  查询所属模型
        $_fid = array_unique(array_column($data,'fid'));
        $_m = new ModularMod();
        $_fid = $_m->GetList(['id' => $_fid],false);
        $_fid = $_m->UntList($_fid);
        $_fid = array_column($_fid,null,'id');

        foreach ($data as &$v){
            $v['fid_name'] = $_fid[$v['fid']]['name'] ?? '';
            $v['fid_name_key'] = $_fid[$v['fid']]['name_key'] ?? '';
            $v['fid_title'] = $_fid[$v['fid']]['title'] ?? '';
            $v['mid'] = $_fid[$v['fid']]['fid'] ?? '';
            $v['mid_title'] = $_fid[$v['fid']]['fid_title'] ?? '';
            $v['mid_name'] = $_fid[$v['fid']]['fid_name'] ?? '';
        }
        return $data;
    }
    //  写入字段
    protected function SetOneCallback($data,$newadd){
        ['mid_name' => $midName, 'fid_name' => $fidName, 'field' => $field, 'title' => $title] = $this->UntModel([$data])[0];
        $tableName = ToUnderScore("{$midName}_{$fidName}", false);
        $file_list = Db::name($tableName)->getTableFields();
        if(in_array($field,$file_list)){
            return $data;
        }
        $config = config('think-orm');
        $connectionName = $config['default'];
        $DbPre = $config['connections'][$connectionName]['prefix'];

        switch ($data['sqlvalue']){
            case 'varchar':
                $sqlvalue = "varchar(255) DEFAULT NULL";
                break;
            case 'int':
                $sqlvalue = "int(11) NOT NULL DEFAULT '0'";
                break;
            case 'bigint':
                $sqlvalue = "bigint(20) NOT NULL DEFAULT '0'";
                break;
            case 'tinyint':
                $sqlvalue = "tinyint(2) NOT NULL DEFAULT '0'";
                break;
            case 'decimal':
                $sqlvalue = "decimal(32,2) unsigned NOT NULL DEFAULT '0'";
                break;
            case 'text':
                $sqlvalue = "text DEFAULT NULL";
                break;
            case 'mediumtext':
                $sqlvalue = "mediumtext DEFAULT NULL";
                break;
            case 'date':
                $sqlvalue = "date DEFAULT NULL";
                break;
            case 'time':
                $sqlvalue = "time DEFAULT NULL";
                break;
            case 'datetime':
                $sqlvalue = "datetime DEFAULT NULL";
                break;
        }
        $sql = "ALTER TABLE `{$DbPre}{$midName}_{$fidName}` ADD `{$field}` {$sqlvalue} COMMENT '{$title}';";
        try {
            Db::execute($sql);
            //  查询缓存是否存在
            $tbname = ToUnderScore("{$midName}_{$fidName}",false);
            if(Cache::has("SQLFILED_{$tbname}")){
                Cache::delete("SQLFILED_{$tbname}");
            }
        } catch(\Exception $e) {
            $this->whereId($data['id'])->delete();
            return false;
        }
        return $data;
    }
}