const EruCms = (() => {
    // 服务器请求
    const ServerRequest = async (url,data = {},method = 'GET',conf = {}) => {
            const config = {
                    timeout: 60000, // 默认10秒超时
                    credentials: 'same-origin', // 默认发送凭证
                    ...conf // 用户自定义配置
                },
                controller = new AbortController(),
                options = {
                    method: method.toUpperCase(),
                    headers: {
                        'Content-Type': method === 'GET' ? 'application/json' : 'application/x-www-form-urlencoded',
                        ...config.headers
                    },
                    credentials: config.credentials,
                    signal: controller.signal,
                    ...config.fetchOptions
                },
                timeoutId = setTimeout(() => {
                    controller.abort();
                    typeof config.timeoutCallback === 'function' && config.timeoutCallback();
                }, config.timeout);
            data = {
                ...data,
                _ajax: 1
            }
            try {
                if (data) {
                    if (['GET', 'HEAD'].includes(options.method)) {
                        const params = new URLSearchParams(data).toString();
                        url += (url.includes('?') ? '&' : '?') + params;
                    } else {
                        if (options.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
                            options.body = new URLSearchParams(data).toString();
                        } else if (options.headers['Content-Type'] === 'application/json') {
                            options.body = JSON.stringify(data);
                        } else {
                            options.body = data;
                        }
                    }
                }
                const response = await fetch(url, options);
                clearTimeout(timeoutId);

                if (!response.ok) {
                    // 尝试获取错误信息
                    let errorData;
                    try {
                        errorData = await response.clone().json();
                    } catch {
                        errorData = await response.clone().text();
                    }
                    const httpError = new Error(`HTTP Error ${response.status}: ${response.statusText}`);
                    httpError.status = response.status;
                    httpError.response = errorData;
                    httpError.url = response.url;
                    throw httpError;
                }

                const res = await response.json();
                typeof conf.success === 'function' && conf.success(res);
                return res;
            } catch (error) {
                clearTimeout(timeoutId);
                if (error.name === 'AbortError') {
                    error = new Error(`请求超时 (${config.timeout}ms)`);
                    error.isTimeout = true;
                } else if (error.name === 'TypeError') {
                    error = new Error('网络错误: 请检查您的连接');
                }
                typeof conf.error === 'function' ? conf.error(error) : '';
                throw error;
            }
        };

    class EruCms {
        constructor() {};
        EGet = (url,data,conf = {}) => ServerRequest(url,data,'GET',conf);
        EPost = (url,data,conf = {}) => ServerRequest(url,data,'POST',conf);


    }
    return EruCms;
})();
