<?php
declare(strict_types=1);
namespace app\common\imtrait;

use think\facade\{Cache, Event};

class ImTag
{
    public function GetMod($data)
    {
        // 缓存键检查和获取优化
        if (!empty($data['setname']) && Cache::has($data['setname'])) {
            return Cache::get($data['setname']);
        }
        return $this->TagMod($data);
    }

    protected function TagMod($data)
    {
        // 直接返回文本/图片类型内容
        if ($data['TagModular'] === 'base' && in_array($data['TagMod'], ['@text@', '@pic@'], true)) {
            $res = $data['template'] ?? '';
        } else {
            // 分支逻辑优化
            $res = ($data['TagModular'] === 'base') ? $this->GetBaseData($data) : $this->GetModData($data);
        }
        // 文件编辑处理后设置缓存
        $res = FileEditAdd($res, false, true);
        if (!empty($data['setname'])) {
            Cache::set($data['setname'], $res, 3600);
        }
        return $res;
    }

    protected function GetBaseData($data)
    {
        // 模型名称标准化处理
        $modelName = "app\\common\\model\\" . ToUnderScore($data['TagMod'], false);
        $model = new $modelName;
        // 查询条件优化
        $map = $this->buildQueryConditions($data);
        $paginationFlag = isset($data['conf']['pages']) && $data['conf']['pages'] === '0';
        $result = $model->GetList($map, $paginationFlag);

        return $this->processModelResult($result, $model, $data);
    }

    protected function GetModData($data)
    {
        // 事件触发结果缓存
        $modEvent = Event::trigger('Mod', [
            'type' => 'GetMod',
            'data' => ['mod' => $data['TagMod'], 'model' => $data['TagModular']]
        ]);
        $homeListEvent = Event::trigger('Mod', [
            'type' => 'GetHomeList',
            'data' => ['mod' => $data['TagMod'], 'model' => $data['TagModular']]
        ]);
        // 快速失败检查
        if ($modEvent[0]['code'] !== '1' || $homeListEvent[0]['code'] !== '1') {
            return [];
        }
        // 模型实例化
        $modData = $modEvent[0]['data'];
        $modelClass = "app\\{$modData['fid_name']}\\model\\{$modData['name_key']}";
        $model = new $modelClass;
        // 查询条件处理
        $map = $this->buildQueryConditions($data);
        if (method_exists($model, 'TagMap')) {
            $map = $model->TagMap($map);
        }
        // 数据获取和处理
        $paginationFlag = !in_array($modData['pages'], ['2']);
        $result = $model->GetList($map, $paginationFlag);
        return $this->processModelResult($result, $model, $data);
    }

    /**
     * 统一处理模型返回结果
     */
    protected function processModelResult($result, $model, $data)
    {
        $isSingleItemRequest = empty($data['TagType']);
        $fieldsToFilter = !empty($data['TagField']) ? explode(',', $data['TagField']) : [];
        // 分页结果处理
        if (isset($result['total'])) {
            $result['data'] = $model->UntList($result['data']);
            if (method_exists($model, 'TagCallback')) {
                $result['data'] = $model->TagCallback($result['data']);
            }
            if (!empty($fieldsToFilter)) {
                foreach ($result['data'] as $k => $v) {
                    $result['data'][$k] = DelArrayFile($v, $fieldsToFilter);
                }
            }
            return $isSingleItemRequest ? ($result['data'][0] ?? []) : $result;
        }
        // 非分页结果处理
        $result = $model->UntList($result);
        if (method_exists($model, 'TagCallback')) {
            $result = $model->TagCallback($result);
        }
        if (!empty($fieldsToFilter)) {
            foreach ($result as $k => $v) {
                $result[$k] = DelArrayFile($v, $fieldsToFilter);
            }
        }
        return $isSingleItemRequest ? ($result[0] ?? []) : $result;
    }
    /**
     * 构建查询条件（优化参数处理）
     */
    protected function buildQueryConditions($data)
    {
        $conditions = $data['conf'] + ['status' => '1'];
        // 参数直接处理，避免多次检查
        $optionalParams = [
            'TagField' => 'GetFile',
            'TagLimit' => 'limit',
            'TagOrder' => 'order'
        ];
        foreach ($optionalParams as $src => $dest) {
            if (!empty($data[$src])) {
                $conditions[$dest] = $data[$src];
            }
        }
        return $conditions;
    }
}
