<?php
declare(strict_types = 1);
namespace app\cms\controller;
use app\common\hook\NodeFormat;
use think\facade\Event;
use think\facade\Session;
use think\facade\View;

class Part extends Base
{
    protected $ArticleModel;
    protected $PartList;
    protected $Read;
    protected $conf;
    protected function initialize()
    {
        parent::initialize();
        $this->BaseModel('Part','model','cms');
        $this->BaseModel('Article','ArticleModel','cms');
        $this->list_base['base_part'] = 'cms:part';
        $this->GetConf();
        $this->GetPartList();
    }

    protected function ReadCallback($data){
        if(empty($data) || $data['status'] != '1'){
           ResClient('内容不存在','0','',GetEruUrl('home/Index/index'));
        }
        if(!empty($data['password']) && !Session::get("cms_part_{$data['id']}_pwd")){
            Redirect(GetEruUrl("check",['id' => $data['id']]));
        }
        if(!empty($data['jumpurl'])){
            Redirect($data['jumpurl'],'302','3');
        }
        $this->EditTdk($data);
        $this->GetRead($data['id']);
        $listdb = $this->GetArticleList();
        View::assign(['listdb' => $listdb]);
        return $this->Read;
    }
    //  验证密码
    public function check(){
        $this->list_base['url'] = GetEruUrl('check',['id' => $this->getdata['id']]);
        $this->GetRead($this->getdata['id']);
        if($this->request->isPost()){
            $data = $this->SaveCheck();
            if(empty($data['password'])){
                ResClient('请输入访问密码','0');
            }
            if($data['password'] != $this->Read['password']){
                ResClient('访问密码错误','0');
            }
            Session::set("cms_part_{$this->getdata['id']}_pwd",true);
            ResClient('验证成功','1','',GetEruUrl('read',['id' => $this->getdata['id']]));
        }
        $this->EditTdk($this->Read);
        return $this->ResHomeRead($this->Read);
    }

    protected function GetListDbCallback($data){
        $data = NodeFormat::toList($data);
        return $data;
    }
    protected function GetConf(){
        $res = Event::trigger('Mod',['type' => 'GetMod','data' => ['mod' => 'part','model' => 'cms']]);
        if($res['0']['code'] != '1'){
            ResClient($res['0']['msg'],'0');
        }
        $this->conf = $res['0']['data'];
        switch ($this->conf['pages']){
            case '1':
                $this->list_base['page'] = false;
                break;
            case '2':
                $this->list_base['page'] = false;
                $this->list_base['fold'] = true;
                break;
        }
    }
    //  查询栏目列表
    protected function GetPartList()
    {
        $this->PartList = $this->model->GetList(['status' => '1'],$this->list_base['page']);
        $this->PartList = $this->model->UntList($this->PartList);
        $this->PartList = NodeFormat::toList($this->PartList);
        $this->PartList = FileEditAdd($this->PartList,false,true);
        View::assign(['partlist' => $this->PartList]);
    }
    //  查询当前栏目
    protected function GetRead($id)
    {
        $this->Read = DelFile($this->PartList,'id',$id);
        $this->Read = $this->Read['0'];
        $this->Read['node'] = NodeFormat::toLayer($this->PartList,$this->Read['id']);
        $_menu = NodeFormat::getParents($this->PartList,$this->Read['id']);
        foreach ($_menu as $v){
            if(empty($this->Read['banner'])){
                $this->Read['banner'] = $v['banner'] ?: $this->Read['banner'];
            }
            if(empty($this->Read['logo'])){
                $this->Read['logo'] = $v['logo'] ?: $this->Read['logo'];
            }
            if(empty($this->Read['list_num'])){
                $this->Read['list_num'] = $v['list_num'] ?: $this->Read['list_num'];
            }
            if(empty($this->Read['title_num'])){
                $this->Read['title_num'] = $v['title_num'] ?: $this->Read['title_num'];
            }
            if(empty($this->Read['cont_num'])){
                $this->Read['cont_num'] = $v['cont_num'] ?: $this->Read['cont_num'];
            }
            if(empty($this->Read['temp_late'])){
                $this->Read['temp_late'] = $v['temp_late'] ?: $this->Read['temp_late'];
            }
        }
        //  检测模板是否存在
        if(!empty($this->Read['temp_late']) && $this->Read['temp_late'] != 'default'){
            if(is_file(public_path("home/{$this->webdb['web_template']}/template/cms/article_list")."{$this->Read['temp_late']}.htm")){
                $this->Read['temp_late'] = "public/home/{$this->webdb['web_template']}/template/cms/article_list/{$this->Read['temp_late']}.htm";
            } else {
                $this->Read['temp_late'] = "public/home/default/template/cms/article_list/{$this->Read['temp_late']}.htm";
            }
        } else {
            $this->Read['temp_late'] = "public/home/default/template/cms/article_list/default.htm";
        }
        View::assign(['menu' => $_menu]);
    }
    //  查询内容列表
    protected function GetArticleList(){
        $_fid = [];
        if(!empty($this->Read['node'])){
            //  去除禁止在上级显示的
            $partlist = DelFile($this->PartList,'pid_see','1');
            //  去除需要密码访问的
            foreach ($partlist as $k => $v){
                if (!empty($v['password'])){
                    unset($partlist[$k]);
                }
            }
            $_fid = NodeFormat::getChildsId($partlist,$this->Read['id']);
        }
        array_push($_fid,$this->Read['id']);
        $res = $this->ArticleModel->GetList(['fid' => $_fid,'order' => $this->Read['articleorder'] ?: '','limit' => $this->Read['list_num'] ?: '']);
        if($res['total'] > '0'){
            $res['data'] = $this->ArticleModel->UntList($res['data']);
            foreach ($res['data'] as $k => $v){
                if(!empty($this->Read['title_num'])){
                    $v['title'] = GetWordNum($v['title'],$this->Read['title_num']);
                }
                if(!empty($this->Read['cont_num'])){
                    $v['description'] = GetWordNum($v['description'],$this->Read['cont_num']);
                }
                $res['data'][$k] = $v;
            }
        }
        return $res;
    }

}