<?php
declare(strict_types = 1);
namespace app\cms\controller\api;

use think\facade\Event;

class Article extends Base
{
    protected function initialize()
    {
        parent::initialize();
        $this->CheckAuth(['create','edit','del'],'api','cms.article');
        $this->BaseModel('Article','model','cms');
        $this->list_base['base_part'] = 'cms:article';

        switch ($this->request->action()){
            case 'create':
            case 'edit':
            case 'save':
                if(!$this->IsLogin()){
                    ResJson('','非法访问','0');
                }
                $this->FormFile();
                break;
        }
    }
    protected function FormFile(){
        $form_file = Event::trigger('AutoFun',['fun' => 'EruFormList','data' => ['mod' => 'Article','model' => 'cms']]);
        if(empty($form_file['0']['code'])){
            ResJson('',$form_file['0']['msg'],'0');
        }
        $this->list_file = $form_file['0']['data']['filelist'];
        array_push($this->list_file,
            ['filed' => 'uid','title' => 'UID','required' => true,'type' => 'hidden','default' => $this->ImUser['cid']],
            ['filed' => 'cid','title' => 'CID','required' => true,'type' => 'hidden','default' => $this->ImUser['cid']],
            ['filed' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '草稿','value' => '0'],['title' => '禁用','value' => '2']],'default' => '1','required' => true]
        );
        if($this->request->action() == 'edit'){
            array_push($this->list_file,['filed' => 'id','title' => 'ID','required' => true,'type' => 'hidden'],
                ['filed' => '_method','title' => 'METHOD','default' => 'PUT','required' => true,'type' => 'hidden']);
        }
    }
}