<?php
declare(strict_types = 1);
namespace app\common\imtrait;

use app\common\hook\ImField;

trait ImTrait
{
    public function index(){
        $_view = ToUnderScore($this->space_name ?? 'home',false);
        $_view = "Res{$_view}List";
        if(!method_exists($this,$_view)){
            ResClient("渲染方法{$_view}不存在",'0');
        }
        //  处理前置条件
        $map = method_exists($this,'IndexSelf') ? $this->IndexSelf($this->getdata) : [];
        // 如果需要获取数据，则读取数据
        $res = $this->ModelGetList ? $this->GetListDb($map) : [];
        //  获取数据后进行二次处理
        if(method_exists($this,'IndexCallback')){
            $res = $this->IndexCallback($res);
        }

        return $this->$_view($res);
    }

    public function create(){
        $_view = ToUnderScore($this->space_name ?: 'home',false);
        $_view = "Res{$_view}Form";
        if(!method_exists($this,$_view)){
            ResClient("渲染方法{$_view}不存在",'0');
        }
        //  处理前置条件
        if(method_exists($this,'CreateSelf')){
            $this->CreateSelf($this->getdata);
        }
        return $this->$_view($this->getdata);
    }
    public function edit(){
        $this->getdata[$this->model->getPk()] = $this->getdata[$this->model->getPk()] ?? $this->getdata['id'];
        if(empty($this->getdata[$this->model->getPk()])){
            ResClient('非法访问','0');
        }
        $_view = ToUnderScore($this->space_name ?: 'home',false);
        $_view = "Res{$_view}Form";
        if(!method_exists($this,$_view)){
            ResClient("渲染方法{$_view}不存在",'0');
        }
        $resdata = $this->model->EditOne($this->getdata[$this->model->getPk()]);
        //  编辑前回调
        if(method_exists($this,'EditSelf')){
            $resdata = $this->EditSelf($resdata);
        }
        return $this->$_view($resdata);
    }

    public function save(){
        if(!$this->user_auth['create'] && !$this->user_auth['edit']){
            ResClient('非法访问','0');
        }
        $data = $this->SaveCheck();
        //  如果是编辑数据，则查询原有数据
        $old = $data[$this->model->getPk()] ?? [];
        if (!empty($old)) {
            $old = $this->model->EditOne($old);
        }
        //  保存前回调
        if(method_exists($this,'SaveSelf')){
            $data = $this->SaveSelf($data,empty($old) ? [] : $old);
        }
        //  如果存在表单，则进行表单处理
        if(!empty($this->list_file)){
            $_m = new ImField();
            $data = $_m->SetForm($this->list_file,$data,$old);
            if(empty($data['code'])){
                ResClient($data['msg'],'0');
            }
            $data = $data['data'];
        }
        //  如果存在主键，则重新赋值
        if(!empty($old[$this->model->getPk()])){
            $data[$this->model->getPk()] =  $old[$this->model->getPk()];
        }
        //  格式化数据
        $data = $this->model->EditAdd($data);
        //  定义返回数据
        $_res = !empty($data[$this->model->getPk()]) ? '更新' : '新增';
        $res = method_exists($this,'SaveRes') ? $this->SaveRes($data) : [];
        //  保存数据
        if(!$add = $this->model->SetOne($data)){
            ResClient(!empty($res['error_msg']) ? $res['error_msg'] : "{$_res}失败",'0');
        }
        //  保存后回调
        if(method_exists($this,'SaveCallback')){
            $add = $this->SaveCallback($add);
        }
        ResClient(!empty($res['success_msg']) ? $res['success_msg'] : "{$_res}成功",'1',$add,!empty($res['url']) ? $res['url'] : '');
    }
    public function del(){
        if($this->request->method() != 'POST' && !$this->user_auth['del']){
            ResClient('非法访问', '0');
        }
        $_pk = $this->model->getPk();
        if(!empty($this->getdata['_d']) && $this->getdata['_d'] == 'p'){
            $id = $this->SaveCheck();
            $this->getdata[$_pk] = array_unique(array_column($id['data'],$_pk));
        }
        if($_pk != 'id' && !empty($this->getdata['id'])){
            $this->getdata[$_pk] = $this->getdata['id'];
            unset($this->getdata['id']);
        }
        if(empty($this->getdata[$_pk])){
            ResClient('非法访问','0');
        }
        if(method_exists($this,'DelSelf')){
            $this->DelSelf($this->getdata[$_pk]);
        }
        if(!$this->model->DelData($this->getdata[$_pk])){
            ResClient("删除失败", '0');
        }
        if(method_exists($this,'DelCallback')){
            $this->DelCallback($this->getdata[$_pk]);
        }
        ResClient("删除成功");
    }
    public function read(){
        $_pk = $this->model->getPk();
        if($_pk != 'id' && !empty($this->getdata['id'])){
            $this->getdata[$_pk] = $this->getdata['id'];
            unset($this->getdata['id']);
        }
        if(empty($this->getdata[$_pk])){
            if(!empty($this->space_name) && $this->space_name == 'api'){
                ResClient("非法访问",'0');
            }
            ResClient("非法访问",'0');
        }
        $_view = empty($this->space_name) || !$this->space_name ? app('http')->getname() : $this->space_name;
        $_view = toUnderScore($_view,false);
        $_view = empty($this->resView) ? "Res{$_view}Read" : $this->resView;
        if(!method_exists($this,$_view)){
            if(!empty($this->space_name) && $this->space_name == 'api'){
                ResClient("方法不存在",'0');
            }
            ResClient("方法不存在",'0');
        }
        $resdata = $this->model->GetOne($this->getdata[$_pk]);
        if(method_exists($this,'ReadCallback')){
            $resdata = $this->ReadCallback($resdata);
        }
        return $this->$_view($resdata);
    }

    /**
     * 快速编辑
     * @return void
     */
    public function fastedit(){
        if(!$this->user_auth['edit']){
            ResClient('非法访问1');
        }
        $this->validate = false;
        $data = $this->SaveCheck();
        $update = [
            $this->model->getPk() => $data['data'][$this->model->getPk()],
            $data['filed'] => $data['value']
        ];
        //  保存前回调
        if(method_exists($this,'FastEditSelf')){
            $update = $this->FastEditSelf($update);
        }
        //  格式化数据
        $update = $this->model->EditAdd($update);
        //  保存数据
        if(!$add = $this->model->SetOne($update)){
            ResClient("处理失败",'0');
        }
        //  保存后回调
        if(method_exists($this,'FastEditCallback')){
            $add = $this->FastEditCallback($add);
        }
        ResClient("处理成功");
    }

    public function getlist(){
        $getlist = $this->GetListDb();
        //  获取数据后回调
        if(method_exists($this,'GetListCallback')){
            $getlist = $this->GetListCallback($getlist);
        }
        $getlist = FileEditAdd($getlist,false);
        ResJson($getlist,"获取成功",'1');
    }
    //  后台页面渲染
    protected function ResAdminList($data = []){
        //  返回数据前的数据处理
        if(method_exists($this,'ListCallback')){
            $data = $this->ListCallback($data);
        }
        $data = FileEditAdd($data,false);
        if($this->request->isAjax()){
            ResClient('查询成功','1',$data);
        }
        $_temp = $this->CheckTemplate('public:table_base');
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        return view($_temp['template'],[
            'list_base' => $this->list_base ?? [],
            'list_file' => $this->list_file ?? [],
            'list_nav' => $this->list_nav ?? [],
            'list_search' => $this->list_search ?? [],
            'listdb' => $data,
        ]);
    }
    protected function ResAdminForm($data = []){
        $data = FileEditAdd($data,false);
        if(!empty($this->list_file)){
            $_m = new ImField();
            $this->list_file = $_m->EditForm($this->list_file,$data);
        }
        $res = [
            'form_list' => empty($this->list_file) ? [] : $this->list_file,
            'postdb' => $data,
        ];
        if($this->request->isAjax()){
            ResClient("获取成功",'1',$res);
        }
        $_temp = $this->CheckTemplate('public:form_base');
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        $res['list_base'] =  $this->list_base ?? [];
        $res['list_nav'] =  $this->list_nav ?? [];
        return view($_temp['template'],$res);
    }
    protected function ResAdminRead($data = []){
        $data = FileEditAdd($data,false);
        $res = [
            'readdb' => $data,
        ];
        if($this->request->isAjax()){
            ResJson($data,"获取成功");
        }
        $_temp = $this->CheckTemplate('public:read_base');
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        $res['list_base'] =  $this->list_base ?? [];
        $res['list_nav'] =  $this->list_nav ?? [];
        return view($_temp['template'],$res);
    }

    protected function ResTagForm($data = []){
        $data = FileEditAdd($data,false);
        $res = [
            'homeread' => empty($this->list_file) ? [] : $this->list_file,
            'postdb' => $data,
        ];
        if($this->request->isAjax()){
            ResJson($res,"获取成功");
        }
        $_temp = $this->CheckTemplate('public:tag_base');
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        $res['list_base'] =  $this->list_base ?? [];
        $res['list_nav'] =  $this->list_nav ?? [];
        return view($_temp['template'],$res);
    }
    //  前台页面渲染
    protected function ResHomeList($data = []){
        //  返回数据前的数据处理
        if(method_exists($this,'ListCallback')){
            $data = $this->ListCallback($data);
        }
        $res = [
            'list_base' => $this->list_base ?? [],
            'listdb' => $data,
        ];
        if($this->request->isAjax()){
            ResJson($res,"查询成功");
        }
        $_temp = $this->CheckTemplate();
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        return view($_temp['template'],[
            'list_base' => $this->list_base ?? [],
            'list_file' => $this->list_file ?? [],
            'list_nav' => $this->list_nav ?? [],
            'list_search' => $this->list_search ?? [],
            'listdb' => $data,
        ]);
    }
    protected function ResHomeRead($data = []){
        //  返回数据前的数据处理
        $data = FileEditAdd($data,false);
        $res = [
            'list_base' => $this->list_base ?? [],
            'readdb' => $data,
        ];
        if($this->request->isAjax()){
            ResJson($res);
        }
        $_temp = $this->CheckTemplate('public:default_read');
        if(empty($_temp['code'])){
            ResClient($_temp['template'],'0');
        }
        return view($_temp['template'],$res);
    }
    //  API数据返回
    protected function ResApiRead($data = []){
        $data = FileEditAdd($data,false,true);
        $res = [
            'list_base' => $this->list_base ?? [],
            'readdb' => $data,
        ];
        ResJson($res);
    }
    protected function ResApiForm($data = []){
        $data = FileEditAdd($data,false,true);
        if(!empty($this->list_file)){
            $_m = new ImField();
            $this->list_file = $_m->EditForm($this->list_file,$data);
        }
        $res = [
            'list_base' => $this->list_base ?? [],
            'form_list' => empty($this->list_file) ? [] : $this->list_file,
            'postdb' => $data,
        ];
        ResJson($res);
    }
    /**
     * 通用查询数据
     * @param array $data 额外查询条件
     * @return array 返回结果
     */
    protected function GetListDb($data = []){
        //  打包查询条件
        $map = array_merge($this->getdata,$data);
        //  查询前回调处理
        if(method_exists($this,'GetListDbSelf')){
            $map = $this->GetListDbSelf($map);
        }
        //  格式化数据
        $reslist = $this->model->GetList($map,$this->list_base['page']);
        //  默认对数组进行解析操作，如果不需要解析则跳过
        if(!isset($this->getdata['_u']) && method_exists($this->model,'UntList')){
            if(isset($reslist['total'])){
                $reslist['data'] = $this->model->UntList($reslist['data']);
            } else {
                $reslist = $this->model->UntList($reslist);
            }
        }
        //  获取数据后回调
        if(method_exists($this,'GetListDbCallback')){
            $reslist = $this->GetListDbCallback($reslist);
        }
        return $reslist;
    }
    /** 数据验证    **/
    protected function SaveCheck():array{
        if(!in_array($this->request->method(),['POST','PUT'])){
            ResJson('', '非法访问', '0');
        }
        $data = DataTrim($this->request->post());
        // 验证数据
        if ($this->validate) {
            $scene = empty($data[$this->model->getPk()]) ? 'add' : 'edit';
            if (!empty($this->validate_scene)) {
                $scene = $this->validate_scene[$scene] ?? $scene;
            }
            if (!$this->validate->scene($scene)->check($data)) {
                ResJson('', $this->validate->getError(), '0');
            }
        }
        return $data;
    }
    //  获取模板
    protected function CheckTemplate($default = ''){
        //  初始化模板
        $_controller = ToUnderScore($this->request->controller());
        $_action = ToUnderScore($this->request->action());
        $_default = empty($this->list_base['base_part']) ? $_controller . '/' . $_action : $this->list_base['base_part'] . '_' . $_action;
        $_temp = $this->list_base['template'] ?: $_default;
        //  获取模板
        $res = $this->GetViewFile($_temp);
        if(empty($res['code']) && $default){
            $res = $this->GetViewFile($default);
        }
        if(empty($res['code'])){
            $res['template'] = '模板文件：' . str_replace(public_path(),'',$res['template']) . ' 不存在';
        }
        return $res;
    }

}