<?php
declare(strict_types = 1);
namespace app\common\model;

use think\db\exception\DbException;
use think\facade\Cache;
use think\facade\Db;

class ModularMod extends R
{
    //  新增后回调
    protected function SetOneSelf($data){
        if(!empty($data['id'])){
            return $data;
        }
        $data['name_key'] = ToUnderScore($data['name'],false);
        return $data;
    }
    protected function UntModel($data){
        $_fid = array_unique(array_column($data,'fid'));
        $_m = new Modular();
        $_fid = $_m->GetList(['id' => $_fid],false);

        $_fm = new ModularField();
        foreach ($data as &$v){
            $_v = DelFile($_fid,'id',$v['fid']);
            $v['fid_title'] = empty($_v['0']['title']) ? '' : $_v['0']['title'];
            $v['fid_name'] = empty($_v['0']['name']) ? '' : $_v['0']['name'];
            $v['field_num'] = $_fm->CountList(['fid' => $v['id'],'table_type' => 'count']);
            try {
                $v['cont_num'] = Db::name("{$v['fid_name']}_{$v['name']}")->count();
            } catch (DbException $e) {
                $v['cont_num'] = '0';
            }
        }
        return $data;
    }
    //  生成数据库
    public function NewSetSql($model,$file,$title){
        $database = config('database');
        $DbPre = $database['connections'][$database['default']]['prefix'];
        $query = Db::query("SHOW TABLES LIKE '{$DbPre}{$model}_{$file}'");
        if(!empty($query)){
            return true;
        }
        $query = "CREATE TABLE IF NOT EXISTS `{$DbPre}{$model}_{$file}` (
                        `id` bigint(20) NOT NULL auto_increment COMMENT 'ID',
                        `cid` bigint(20) DEFAULT 0 COMMENT '企业ID',
                        `uid` bigint(20) DEFAULT 0 COMMENT '用户UID',
                        `sort` int(11) DEFAULT 0 COMMENT '排序',
                        `hist` bigint(20) DEFAULT 0 COMMENT '访问量',
                        `status` tinyint(4) DEFAULT 0 COMMENT '状态，0=>草稿，1=>启用，2=>禁用',
                        `addtime` datetime DEFAULT NULL COMMENT '添加时间',
                        `edittime` datetime DEFAULT NULL COMMENT '编辑时间',
                        `del_time` datetime DEFAULT NULL COMMENT '删除时间',
                        `addip` varchar(255) DEFAULT NULL COMMENT '添加IP',
                        `ropt` int(11) DEFAULT NULL COMMENT '端口',
                        PRIMARY KEY  (`id`)
                   ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='{$title}表' AUTO_INCREMENT=1;";
        try {
            Db::execute($query);
        } catch(\Exception $e) {
            return false;
        }
        return true;
    }
    //  生成权限
    public function NewSetAuth($model,$file,$title){
        $_m = new AuthRule();
        $_old = $_m->GetList(['model' => $model,'name' => $file],false);
        if(count($_old) > '0'){
            return true;
        }
        $add = [
            'model' => $model,
            'name' => $file,
            'title' => $title,
            'status' => '1',
        ];
        $add = $_m->EditAdd($add);
        if($_m->SetOne($add)){
            return true;
        }
        return false;
    }
    //  生成文件
    public function NewSetFile($data){
        //  生成模型
        if(!file_exists("app/{$data['fid_name']}/model/{$data['name_key']}.php")) {
            $res = WriteFile(base_path("{$data['fid_name']}/model") . "{$data['name_key']}.php", self::_ModelBase($data));
            if(empty($res['code'])){
                return false;
            }
        }
        $_contlist = explode(',',$data['open']);
        if(count($_contlist) > '0'){
            foreach ($_contlist as $v){
                $_vfilename = $v == 'home' ? "{$data['fid_name']}/controller" : "{$data['fid_name']}/controller/{$v}";
                $_vfiledir = $v == 'home' ? '' : $v;
                if(!file_exists("app/{$_vfilename}/{$data['name_key']}.php")) {
                    if(!file_exists("app/{$_vfilename}")) {
                        @mkdir("app/{$_vfilename}",0755,true);
                    }
                    switch ($v){
                        case 'admin':
                            $res = WriteFile(base_path($_vfilename) . "{$data['name_key']}.php", self::_ControllerAdmin($data,$_vfiledir));
                            break;
                        case 'home':
                            $res = WriteFile(base_path($_vfilename) . "{$data['name_key']}.php", self::_ControllerHome($data));
                            break;
                        case 'api':
                            $res = WriteFile(base_path($_vfilename) . "{$data['name_key']}.php", self::_ControllerApi($data,$_vfiledir));
                            break;
                        case 'member':
                            $res = WriteFile(base_path($_vfilename) . "{$data['name_key']}.php", self::_ControllerMember($data,$_vfiledir));
                            break;
                    }
                    if(empty($res['code'])){
                        return false;
                    }
                }
            }
        }
        //  更新模块缓存
        $res = Cache::get("MODULAR");
        unset($res[$data['fid_name']]);
        Cache::set("MODULAR",$res);
        //  更新模型缓存
        $res = Cache::get("MOD_{$data['fid_name']}");
        unset($res[$data['name']]);
        Cache::set("MOD_{$data['fid_name']}",$res);
        //  更新字段缓存
        Cache::delete("MOD_{$data['fid_name']}_{$data['name']}_field");
        Cache::delete("SQLFILED_{$data['fid_name']}_{$data['name']}");
        return true;
    }
    // 基础模型文件
    protected static function _ModelBase($data){
        $_res = "namespace app\\{$data['fid_name']}\\model;";
        $_order = empty($data['list_order']) ? '' : "protected \$_order = '{$data['list_order']}';";
        $res = "<?php
declare(strict_types = 1);
{$_res}

use app\common\model\R;

class {$data['name_key']} extends R
{
    protected \$name = '{$data['fid_name']}_{$data['name']}';
    {$_order}
    
    protected function UntModel(\$data){

        foreach (\$data as &\$v){
            \$v['url'] = \"/{$data['fid_name']}/{$data['name']}-{\$v['id']}.html\";
        }

        return \$data;
    }
}";
        return $res;
    }
    // 生成后台控制文件
    protected static function _ControllerAdmin($data,$name = null){
        $_res = "namespace app\\{$data['fid_name']}\\controller;";
        if(!empty($name)){
            $_res = "namespace app\\{$data['fid_name']}\\controller\\{$name};";
        }
        $res = "<?php
declare(strict_types = 1);
{$_res}

use app\\common\\model\\Tag;
use think\\facade\\Event;

class {$data['name_key']} extends Base
{
    protected \$conf;
    protected function initialize()
    {
        parent::initialize();
        \$this->CheckAuth(['read','create','edit','del'],'admin','{$data['fid_name']}.{$data['name_key']}');
        if(!\$this->user_auth['index']){
            ResClient('没有此权限','0');
        }
        \$this->BaseModel('{$data['name_key']}','model','{$data['fid_name']}');
        \$this->GetConf();
        \$this->list_base['base_part'] = '{$data['fid_name']}:{$data['name']}';
        switch (\$this->request->action()){
            case 'index':
                \$this->list_base['fast_url'] = GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/fastedit',\$this->getdata);
                \$this->list_base['url'] = GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/getlist',\$this->getdata);
                \$this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                \$this->list_base['url'] = GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/save',\$this->getdata);
                \$this->list_base['title'] = \$this->request->action() == 'edit' ? '编辑' : '添加';
                \$this->FormFile();
                break;
        }

    }
    protected function ListTable(){
        \$list_file = Event::trigger('Mod',['type' => 'GetAdminList','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(empty(\$list_file['0']['code'])){
            ResClient(\$list_file['0']['msg'],'0');
        }
        \$this->list_file[] = ['type' => 'checkbox','fixed' => 'left','width' => '50'];
        \$this->list_file = array_merge(\$this->list_file,\$list_file['0']['filelist']);

        \$this->list_base['button'] = [];
        if(\$this->user_auth['create']) {
            array_push(\$this->list_base['button'],['title' => '新增', 'open' => true, 'url' => GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/create',\$this->getdata)]);
        }
        if(\$this->user_auth['read']) {
            array_push(\$this->list_file,
                ['field' => 'read', 'title' => '查看', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-querenfangan', 'url' => GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/read', ['id' => '__id__']),'fixed' => 'right','open' => true,]
            );
        }
        if(\$this->user_auth['edit']) {
            array_push(\$this->list_file,
                ['field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/edit', ['id' => '__id__']),'fixed' => 'right','open' => true,]
            );
        }
        if(\$this->user_auth['del']) {
            array_push(\$this->list_file, [
                'field' => 'del', 'title' => '删除', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-delete', 'url' => GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/del', ['id' => '__id__']),'fixed' => 'right']);
            array_push(\$this->list_base['button'],['title' => '批量删除', 'class' => 'ery-bg-red ery-button', 'event' => 'del', 'url' => GetEruUrl('{$data['fid_name']}/admin.{$data['name_key']}/del',['_d' => 'p'])]);
        }
        if(isset(\$this->list_base['fold']) && \$this->list_base['fold']){
            array_splice(\$this->list_file,0,1);
            foreach (\$this->list_file as \$k => \$v){
                if(!empty(\$v['fixed'])){
                    unset(\$v['fixed']);
                }
                if(!empty(\$v['field']) && in_array(\$v['field'],['addip','addtime','edittime'])){
                    unset(\$this->list_file[\$k]);
                    continue;
                }
                \$this->list_file[\$k] = \$v;
            }
            if(\$this->user_auth['del']) {
                \$this->list_base['button'] = DelFile(\$this->list_base['button'],'title','批量删除',true);
            }
        }
        if(!empty(\$list_file['0']['searchlist'])){
            \$this->list_search['select'] = DelFile(\$list_file['0']['searchlist'],'type','select');
            \$this->list_search['input'] = DelFile(\$list_file['0']['searchlist'],'type','text');
            \$this->list_search['date'] = DelFile(\$list_file['0']['searchlist'],'type','date');
        }
    }
    protected function FormFile(){
        \$form_file = Event::trigger('Mod',['type' => 'GetAdminForm','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(empty(\$form_file['0']['code'])){
            ResClient(\$form_file['0']['msg'],'0');
        }
        \$this->list_file = \$form_file['0']['filelist'];
        if(\$this->conf['pages'] == '2'){
            //  查询上级id字段
            \$_rank = DelFile(\$this->list_file,'type','rank');
            if(!empty(\$_rank)){
                \$_rank = \$_rank['0']['field'];
                \$_partlist = \$this->model->GetList(['status' => '1'],false);
                \$_pid = ['id' => '','on' => false];
                if(!empty(\$this->getdata['id']) || !empty(\$this->getdata[\$_rank])){
                    \$_pid['id'] = \$this->getdata['id'] ?? \$this->getdata[\$_rank];
                    \$_pid['on'] = !empty(\$this->getdata['id']);
                }
                \$_partlist = FormatPart(\$_partlist,\$_pid,['title' => 'title_display']);
                \$_partlist = array_merge([['title' => '顶级菜单','value' => '0']],\$_partlist);

                foreach (\$this->list_file as &\$v){
                    if(\$v['field'] == \$_rank){
                        \$v['type'] = 'select';
                        \$v['list'] = \$_partlist;
                        \$v['default'] = \$this->getdata[\$_rank] ?? '';
                    }
                }
            }

        }
        array_push(\$this->list_file,
            ['field' => 'sort','title' => '排序值','required' => true,'type' => 'number','default' => '0'],
            ['field' => 'uid','title' => 'UID','required' => true,'type' => 'hidden','default' => \$this->ImUser['uid']],
            ['field' => 'cid','title' => 'CID','required' => true,'type' => 'hidden','default' => \$this->ImUser['cid']],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '草稿','value' => '0'],['title' => '禁用','value' => '2']],'default' => '1','required' => true]
        );
        if(\$this->request->action() == 'edit'){
            array_push(\$this->list_file,['field' => 'id','title' => 'ID','required' => true,'type' => 'hidden']);
        }
        \$_group = array_unique(array_column(\$this->list_file,'group'));
        if(count(\$_group) > '1'){
            \$this->list_nav = [];
            unset(\$v);
            foreach (\$_group as \$v) {
                \$_k = count(\$this->list_nav) + 1;
                \$_v = \$v ?? '基础信息';
                foreach (\$this->list_file as &\$v1){
                    \$v1['group'] = \$v1['group'] ?? '';
                    if(\$v1['group'] == \$_v){
                        \$v1['group'] = \$_k;
                    }
                }
                array_push(\$this->list_nav,['title' => \$_v,'value' => \$_k]);
            }
        }
    }
    protected function GetListDbSelf(\$data){
        \$list_file = Event::trigger('Mod',['type' => 'GetAdminList','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(empty(\$list_file['0']['code'])){
            ResClient(\$list_file['0']['msg'],'0');
        }
        \$data['GetFile'] = array_column(\$list_file['0']['filelist'],'field');
        \$data['GetFile'] = array_merge(\$data['GetFile'],['id','uid','cid','sort','hist','status','addtime','addip']);
        if(\$this->conf['pages'] == '2'){
            array_push(\$data['GetFile'],'pid');
        }
        return \$data;
    }
    protected function GetConf(){
        \$res = Event::trigger('Mod',['type' => 'GetMod','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(\$res['0']['code'] != '1'){
            ResClient(\$res['0']['msg'],'0');
        }
        \$this->conf = \$res['0']['data'];
        switch (\$this->conf['pages']){
            case '1':
                \$this->list_base['page'] = false;
                break;
            case '2':
                \$this->list_base['page'] = false;
                \$this->list_base['fold'] = true;
                break;
        }
    }
    public function tag(){
        //  指定模板
        \$this->list_base['template'] = \"tag:{$data['fid_name']}_{$data['name']}\";
        \$res = \$this->GetViewFile(\$this->list_base['template']);
        \$this->list_base['code'] = \$res['code'];
        //  获取标签
        \$_m = new Tag();
        \$read = \$_m->GetOne(\$this->getdata['id']);
        if(!empty(\$this->getdata['init'])){
            \$read['TagModular'] = '{$data['fid_name']}';
            \$read['TagMod'] = '{$data['name']}';
            \$read['latename'] = '';
            \$read['template'] = '';
            \$read['conf'] = [];
        }
        \$form_file = Event::trigger('Mod',['type' => 'GetHomeRead', 'data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        \$this->list_file = \$form_file['0']['homeread'] ?? [];
        return \$this->ResTagForm(\$read);
    }
}";
        return $res;
    }
    protected static function _ControllerMember($data,$name = null){
        $_res = "namespace app\\{$data['fid_name']}\\controller;";
        if(!empty($name)){
            $_res = "namespace app\\{$data['fid_name']}\\controller\\{$name};";
        }
        $res = "<?php
declare(strict_types = 1);
{$_res}

use think\\facade\\Event;

class {$data['name_key']} extends Base
{
    
    protected \$conf;
    protected function initialize()
    {
        parent::initialize();
        \$this->CheckAuth(['read','create','edit','del'],'member','{$data['fid_name']}.{$data['name_key']}');
        \$this->BaseModel('{$data['name_key']}','model','{$data['fid_name']}');
        \$this->GetConf();
        \$this->list_base['base_part'] = '{$data['fid_name']}:{$data['name']}';
        switch (\$this->request->action()){
            case 'index':
                \$this->list_base['url'] = GetEruUrl('getlist',\$this->getdata);
                \$this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                \$this->list_base['url'] = GetEruUrl('save',\$this->getdata);
                \$this->FormFile();
                break;
        }

    }
    protected function ListTable(){
        \$list_file = Event::trigger('Mod',['type' => 'GetMemberList','data' => ['mod' => '{$data['name_key']}','model' => '{$data['fid_name']}']]);
        if(empty(\$list_file['0']['code'])){
            ResClient(\$list_file['0']['msg'],'0');
        }
        \$this->list_file = \$list_file['0']['filelist'];
        if(\$this->user_auth['edit']) {
            array_push(\$this->list_file,
                ['field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('edit', ['id' => '__id__']),'fixed' => 'right']
            );
        }
        if(\$this->user_auth['del']) {
            array_push(\$this->list_file, [
                'field' => 'del', 'title' => '删除', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-delete', 'url' => GetEruUrl('del', ['id' => '__id__']),'fixed' => 'right']);
        }
        if(\$this->user_auth['create']) {
            \$this->list_base['button'] = [
                ['title' => '新增', 'url' => GetEruUrl('create')],
            ];
        }

        if(!empty(\$list_file['0']['data']['listsearch'])){
            \$this->list_search['select'] = DelFile(\$list_file['0']['data']['listsearch'],'type','select');
            \$this->list_search['input'] = DelFile(\$list_file['0']['data']['listsearch'],'type','text');
            \$this->list_search['date'] = DelFile(\$list_file['0']['data']['listsearch'],'type','date');
        }
    }
    protected function FormFile(){
        \$form_file = Event::trigger('Mod',['type' => 'GetAdminForm','data' => ['mod' => '{$data['name_key']}','model' => '{$data['fid_name']}']]);
        if(empty(\$form_file['0']['code'])){
            ResClient(\$form_file['0']['msg'],'0');
        }
        \$this->list_file = \$form_file['0']['filelist'];
        array_push(\$this->list_file,
            ['field' => 'uid','title' => 'UID','required' => true,'type' => 'hidden','default' => \$this->ImUser['uid']],
            ['field' => 'cid','title' => 'CID','required' => true,'type' => 'hidden','default' => \$this->ImUser['cid']],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '草稿','value' => '0'],['title' => '禁用','value' => '2']],'default' => '1','required' => true]
        );
        if(\$this->request->action() == 'edit'){
            array_push(\$this->list_file,['filed' => 'id','title' => 'ID','required' => true,'type' => 'hidden'],
                ['field' => '_method','title' => 'METHOD','default' => 'PUT','required' => true,'type' => 'hidden']);
        }
    }
    protected function GetListDbSelf(\$data){
        \$list_file = Event::trigger('Mod',['type' => 'GetAdminList','data' => ['mod' => '{$data['name_key']}','model' => '{$data['fid_name']}']]);
        if(empty(\$list_file['0']['code'])){
            ResClient(\$list_file['0']['msg'],'0');
        }
        \$data['GetFile'] = array_column(\$list_file['0']['filelist'],'field');
        array_push(\$data['GetFile'],'uid');
         if(!empty(\$this->ImUser['cid'])){
            \$data['cid'] = \$this->ImUser['cid'];
        } else {
            \$data['uid'] = \$this->ImUser['uid'];
        }
        if(\$this->conf['pages'] == '2'){
            array_push(\$data['GetFile'],'pid');
        }
        return \$data;
    }
    protected function GetConf(){
        \$res = Event::trigger('Mod',['type' => 'GetMod','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(\$res['0']['code'] != '1'){
            ResClient(\$res['0']['msg'],'0');
        }
        \$this->conf = \$res['0']['data'];
        switch (\$this->conf['pages']){
            case '1':
                \$this->list_base['page'] = false;
                break;
            case '2':
                \$this->list_base['page'] = false;
                \$this->list_base['fold'] = true;
                break;
        }
    }
}";
        return $res;
    }
    protected static function _ControllerHome($data){
        $_res = "namespace app\\{$data['fid_name']}\\controller;";
        $res = "<?php
declare(strict_types = 1);
{$_res}
use think\\facade\\Event;

class {$data['name_key']} extends Base
{
    protected \$conf;
    protected function initialize()
    {
        parent::initialize();
        \$this->BaseModel('{$data['name_key']}','model','{$data['fid_name']}');
        \$this->list_base['base_part'] = '{$data['fid_name']}:{$data['name']}';
        \$this->GetConf();
    }

    protected function ReadCallback(\$data){
        if(empty(\$data) || \$data['status'] != '1'){
             ResClient('内容不存在','0','',GetEruUrl('home/Index/index'));
        }
        \$this->EditTdk(\$data);
        return \$data;
    }
    protected function GetListDbSelf(\$data){
        \$list_file = Event::emit('mod.GetAdminList',['mod' => '{$data['name']}','model' => '{$data['fid_name']}']);
        if(empty(\$list_file['0']['code'])){
            ResJson(\$list_file['0']['msg'],'0');
        }
        \$data['GetFile'] = array_column(\$list_file['0']['filelist'],'field');
        \$data['GetFile'] = array_merge(\$data['GetFile'],['id','uid','cid','sort','hist','status','addtime','addip']);
        return \$data;
    }
    protected function GetConf(){
        \$res = Event::trigger('Mod',['type' => 'GetMod','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(\$res['0']['code'] != '1'){
            ResClient(\$res['0']['msg'],'0');
        }
        \$this->conf = \$res['0']['data'];
        switch (\$this->conf['pages']){
            case '1':
                \$this->list_base['page'] = false;
                break;
            case '2':
                \$this->list_base['page'] = false;
                \$this->list_base['fold'] = true;
                break;
        }
    }

}";
        return $res;
    }
    protected static function _ControllerApi($data,$name = null){
        $_res = "namespace app\\{$data['fid_name']}\\controller;";
        if(!empty($name)){
            $_res = "namespace app\\{$data['fid_name']}\\controller\\{$name};";
        }
        $res = "<?php
declare(strict_types = 1);
{$_res}

use think\\facade\\Event;

class {$data['name_key']} extends Base
{
    protected \$conf;
    protected function initialize()
    {
        parent::initialize();
        \$this->CheckAuth(['create','edit','del'],'api','{$data['fid_name']}.{$data['name_key']}');
        \$this->BaseModel('{$data['name_key']}','model','{$data['fid_name']}');
        \$this->list_base['base_part'] = '{$data['fid_name']}:{$data['name']}';
        \$this->GetConf();
        switch (\$this->request->action){
            case 'create':
            case 'edit':
            case 'save':
                if(!\$this->IsLogin()){
                    ResJson('','非法访问','0');
                }
                \$this->FormFile();
                break;
        }
    }
    protected function FormFile(){
        \$form_file = Event::emit('mod.GetAdminForm',['mod' => '{$data['name']}','model' => '{$data['fid_name']}']);
        if(empty(\$form_file['0']['code'])){
            ResJson('',\$form_file['0']['msg'],'0');
        }

        \$this->list_file = \$form_file['0']['filelist'];
        array_push(\$this->list_file,
            ['field' => 'uid','title' => 'UID','required' => true,'type' => 'hidden','default' => \$this->ImUser['cid']],
            ['field' => 'cid','title' => 'CID','required' => true,'type' => 'hidden','default' => \$this->ImUser['cid']],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '草稿','value' => '0'],['title' => '禁用','value' => '2']],'default' => '1','required' => true]
        );
        if(\$this->request->action == 'edit'){
            array_push(\$this->list_file,['field' => 'id','title' => 'ID','required' => true,'type' => 'hidden'],
                ['field' => '_method','title' => 'METHOD','default' => 'PUT','required' => true,'type' => 'hidden']);
        }
    }
    protected function ReadCallback(\$data){
        if(empty(\$data) || \$data['status'] != '1'){
            ResJson('','内容不存在','0');
        }
        return \$data;
    }
    protected function GetListDbSelf(\$data){
        \$list_file = Event::emit('mod.GetAdminList',['mod' => '{$data['name']}','model' => '{$data['fid_name']}']);
        if(empty(\$list_file['0']['code'])){
            ResJson('',\$list_file['0']['msg'],'0');
        }
        \$data['GetFile'] = array_column(\$list_file['0']['filelist'],'field');
        \$data['GetFile'] = array_merge(\$data['GetFile'],['id','uid','cid','sort','hist','status','addtime','addip']);
        return \$data;
    }
    protected function GetConf(){
        \$res = Event::trigger('Mod',['type' => 'GetMod','data' => ['mod' => '{$data['name']}','model' => '{$data['fid_name']}']]);
        if(\$res['0']['code'] != '1'){
            ResJson('',\$res['0']['msg'],'0');
        }
        \$this->conf = \$res['0']['data'];
        switch (\$this->conf['pages']){
            case '1':
                \$this->list_base['page'] = false;
                break;
            case '2':
                \$this->list_base['page'] = false;
                \$this->list_base['fold'] = true;
                break;
        }
    }
}";
        return $res;
    }
    //  检测文件是否存在
    public function CheckFile($id){
        $mod = $this->GetOne($id);
        // 检测模型是否存在
        $modelPath = "app/{$mod['fid_name']}/model/{$mod['name_key']}.php";
        if (!file_exists($modelPath)) {
            return false;
        }
        // 检测控制器是否存在
        if ($mod) {
            $mod['open'] = is_array($mod['open']) ? $mod['open'] : explode(',', $mod['open']);
            foreach ($mod['open'] as $v) {
                $controllerPath = $v == 'home' ? "app/{$mod['fid_name']}/controller/{$mod['name_key']}.php" : "app/{$mod['fid_name']}/controller/{$v}/{$mod['name_key']}.php";
                if (!file_exists($controllerPath)) {
                    return false;
                }
            }
        }
        return true;
    }
}